
{  }
{
      HAMEG GmbH
	  Sample program for interface HO79
	  Data transfer to HAMEG oscilloscope;
	  Commands : 'ID?', 'DIG', 'GET'

	  For GPIB data tranfer UNIT HO80_1 has to be bound
	  Choose the unit according to the TP version in use
}
{  }

PROGRAM GPIB;

USES
    DOS,
    CRT,
    HO80_1;

CONST
     ESC    = 27;
     F1     = $3B;
     F2     = $3C;
     F3     = $3D;
     F4     = $3E;
     F10    = $44;

     stop     : boolean = false;

VAR
   data,
   dev      : byte;
   Ch       : char;
   pos     : word;
   cmd     : string;

   DA             : ARRAY[0..$2000] OF BYTE;
   PtrDA          : Pointer;


{  }

   BEGIN

  IF not IEEE_card then HALT;       { terminate if IEEE-488 card not present }
  clrscr;

  Adress := 21;                     { device address of HO80 card }
  Pegel  := 0;                          { System controller                  }
  INIT (Adress, Pegel);                 { activate }

  delay (3000);                         { Initialisation of interface, scope }
  Instrument := $B;                     { address of device                  }

   textcolor (WHITE);
   textbackground (YELLOW);
   textbackground(BLUE);
   clrscr;

   window(1,1,80,2);
   textcolor(YELLOW);
   textbackground(CYAN);
   clreol;
   write('  F1-ID?   F2-DIG   F3-GET                                            F10-EXIT');


   { screen setup }
   textcolor(WHITE);
   textbackground(BLUE);
   window(1,3,80,20);

   { set binary format }
   cmd := 'FRM 0';
   IWD (Instrument, cmd, Status);     { transmit command to instrument }

   REPEAT
      IF keypressed
        THEN BEGIN
        Ch := readkey;
        IF Ch = #0 THEN
		   BEGIN       { function keys }
           Ch := ReadKey;
           Case ord(Ch) OF
              F1  : BEGIN
			  { Get and display scope ID code }
				cmd := 'ID?';
				IWD (Instrument, cmd, Status);     { transmit command to instrument }
				cmd[0]:=chr(20);
				IRD (cmd, Instrument, Status);
				writeln (cmd);                     { display data                    }
                END;
              F2  : BEGIN
			  { request, read, and display data }
				cmd := 'DIG';
				IWD (Instrument, cmd, Status);     { transmit command to instrument }

				cmd := 'MLA TALK 11';              { Attention: device address 11, too ??? }
                IWSD (cmd, Status);

				ANZAHL := SizeOf(DA);
                PtrDa := addr(DA);
				IRDA (PtrDA, ANZAHL, LANG, STATUS);
				writeln (ANZAHL:6, lang:6);
                for pos:=0 TO lang-1 DO
                  write (chr(DA[pos]));
                END;
              F3  : BEGIN
				{ reset trigger of oscilloscope, wait for request (SRQ),
				  get, read, and display data }
				cmd := 'GET';
				IWD (Instrument, cmd, Status);     { transmit command to instrument }

                WHILE ((port[$2B8+2] AND $40) = 0) DO ;
	        ISPL (Instrument, pol, status);

                cmd := 'MLA TALK 11';
                IWSD (cmd, Status);

				ANZAHL := SizeOf(DA);
                PtrDa := addr(DA);
				IRDA (PtrDA, ANZAHL, LANG, STATUS);
				writeln (ANZAHL:6, lang:6);
                for pos:=0 TO lang-1 DO
                  write (chr(DA[pos]));
                END;
              F10 : stop := true;
              END;
           END
           ELSE BEGIN      { Zeichen }
           Case ord(Ch) OF
              ESC : stop := true;
              END;
           END;
        END;
      UNTIL (stop);
   END.
